PRINT '> PRODUCAO - SCRIPT #0019';

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_NFE_VERIFICA_FILIAIS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_NFE_VERIFICA_FILIAIS]
GO

CREATE PROCEDURE [dbo].[P_NFE_VERIFICA_FILIAIS]
AS

	BEGIN TRY DROP TABLE #FILIAIS_HAB_SEM_LICENCA; END TRY BEGIN CATCH END CATCH;

	PRINT 'VERIFICANDO FILIAIS HABILITADAS MAS SEM LICENCA...';
	WITH
		FILIAIS_HABILITADAS AS (
			SELECT
				*
			FROM
				PRC_FILIAL
			WHERE
					FLAG_NFE_HABILITADA = 1 
				OR FLAG_VALIDAR_NOTA_ENTRADA_FORN = 1
		)
		--SELECT * FROM FILIAIS_HABILITADAS
		, FILIAIS_HAB_SEM_LICENCA AS (
			SELECT 
				H.CD_FILIAL
				, H.RZ_FILIAL
				, H.CGC
				, H.FLAG_NFE_HABILITADA
				, H.FLAG_VALIDAR_NOTA_ENTRADA_FORN
				, L.CNPJ
				, L.UF
				, L.LICENCA
				, L.CHAVE
			FROM FILIAIS_HABILITADAS H
			LEFT JOIN NFE..EST_NF_NFE_LICENCAS L ON
				L.CD_FILIAL = H.CD_FILIAL
			WHERE
				RTRIM(LTRIM(COALESCE(L.UF,''))) = ''
				OR RTRIM(LTRIM(COALESCE(L.CHAVE,''))) = ''
				OR RTRIM(LTRIM(COALESCE(L.LICENCA,''))) = ''
		)
		SELECT 
			*
		INTO #FILIAIS_HAB_SEM_LICENCA
		FROM FILIAIS_HAB_SEM_LICENCA;

	IF EXISTS(SELECT 1 FROM #FILIAIS_HAB_SEM_LICENCA)
	BEGIN
		PRINT 'DESABILITANDO FILIAIS SEM LICENCA...';
		
		UPDATE 
			PRC_FILIAL 
		SET 
			FLAG_NFE_HABILITADA = 0
			, FLAG_VALIDAR_NOTA_ENTRADA_FORN = 0
		WHERE 
			CD_FILIAL IN (SELECT CD_FILIAL FROM #FILIAIS_HAB_SEM_LICENCA);
			
		PRINT 'FILIAIS DESABILITANDAS!';
	END
	ELSE
	BEGIN
		PRINT 'NENHUMA FILIAL EM SITUACAO IRREGULAR FOI LOCALIZADA.';
	END;

	BEGIN TRY DROP TABLE #FILIAIS_HAB_SEM_LICENCA; END TRY BEGIN CATCH END CATCH;
GO

PRINT '    < [OK]';